%get pso parameters used in local affine registration

function options = get_local_pso_params(verbose)

    options = get_psoOptions;

    options.Flags.ShowViz = 0;
    options.Flags.Neighbor = 0;

    options.Vars.SwarmSize = 40;
    options.Vars.Dim = 5;
    options.Vars.Iterations = 45;
    options.Vars.ErrGoal = 0.001;

    options.SParams.c1 = 2.05;
    options.SParams.c2 = 2.05;
    options.SParams.w_start = 1.0;
    options.SParams.w_end = 0.1;
    options.SParams.Vmax = 1;

    options.Obj.f2eval = 'doAffine';
    options.Obj.lb = 0;
    options.Obj.ub = 1;

    options.Terminate.Iters = 1;
    options.Terminate.Err = 0;

    options.Save.Interval = 0;
    if verbose > 0
        options.Disp.Interval = 10; %display results frequency
    else
        options.Disp.Interval = 0;
    end
    options.Disp.Footer = 1;
    options.Disp.Progress = 1;

end